%% PLOTTING C60 SENSOR'S I-V and R-V CURVES

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'all_iv_curves_C60Sensor_cubic.csv',...       % Targets [0,29], cubic spline interpolation, linear extrapolation                
%          'iv_C60Sensor_curves_cubic.csv',...         % Targets [0,5], cubic spline interpolation, linear extrapolation
%          'iv_C60Sensor_curves_quadratic.csv',...     % Targets [0,5], quadratic spline interpolation, linear extrapolation
%          'iv_C60Sensor_curves_linear.csv',...        % Targets [0,5], linear interpolation, linear extrapolation
         };       
     
[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file


%% Extracting data
importfile(file);
[raws,columns] = size(data);

number_target = columns/2;
Vctrl = [0:1:number_target-1];
i = 1;

labels_gas = {'C_{60} + no gas',...                     % Vctrl = 0 V;                                             
              'C_{60} + NH_{3} (N down)',...            % Vctrl = 1 V;
              'C_{60} + NH_{3} (O down)',...            % Vctrl = 2 V;
              'C_{60} + Ar',...                         % Vctrl = 3 V;
              'C_{60} + CO',...                         % Vctrl = 4 V;
              'C_{60} + CO_{2}',...                     % Vctrl = 5 V;
              'C_{60} + N_{2}',...                      % Vctrl = 6 V;
              'C_{60} + H_{2}O (flat)',...              % Vctrl = 7 V;
              'C_{60} + H_{2}O (H down)',...            % Vctrl = 8 V;
              'C_{60} + H_{2}O (O down)',...            % Vctrl = 9 V;
              'C_{60} + O_{2}',...                      % Vctrl = 10 V;
              'C_{60} + CH_{4}',...                     % Vctrl = 11 V;
              'C_{60} + C_{4}H_{10}',...                % Vctrl = 12 V;
              'C_{60} + PbSO_{4} (flat)',...            % Vctrl = 13 V;
              'C_{60} + PbSO_{4} (flat rotated)',...    % Vctrl = 14 V;
              'C_{60} + PbSO_{4} (flat up-down)',...    % Vctrl = 15 V;
              'C_{60} + PbSO_{4} (SO down)',...         % Vctrl = 16 V;
              'C_{60} + PbSO_{4} (Pb down)',...         % Vctrl = 17 V;
              'C_{60} + NO (O down)',...                % Vctrl = 18 V;
              'C_{60} + NO (N down)',...                % Vctrl = 19 V;
              'C_{60} + NO (flat)',...                  % Vctrl = 20 V;
              'C_{60} + PbO (O down)',...               % Vctrl = 21 V;
              'C_{60} + PbO (flat)',...                 % Vctrl = 22 V;
              'C_{60} + PbO (Pb down)',...              % Vctrl = 23 V;
              'C_{60} + PbCl_{2} (flat)',...            % Vctrl = 24 V;
              'C_{60} + PbCl_{2} (Cl down)',...         % Vctrl = 25 V;
              'C_{60} + PbCl_{2} (Pb down)',...         % Vctrl = 26 V;
              'C_{60} + NO_{2} (O down)',...            % Vctrl = 27 V;
              'C_{60} + NO_{2} (N down)',...            % Vctrl = 28 V;
              'C_{60} + NO_{2} (flat)',...              % Vctrl = 29 V;
              };


for i_target = 1:2:columns 

    I_DS(:,i) = data(:,i_target+1);     % [A]
    V_DS(:,i) = data(:,i_target);       % [V]

    labels(:,i) = labels_gas(:,i); 


    Delta_I_DS(:,i) = I_DS(:,i) - I_DS(:,1);                    % [A]
    Delta_I_DS_perc(:,i) = (Delta_I_DS(:,i)./I_DS(:,1))*100;    % [%]
    i=i+1;
    
end

% % PLOT SBALLATO DELLA RESISTENZA
% dV_DS = min(V_DS(2,:) - V_DS(1,:));
% % G_sens = [0 0 0 0 0 0; diff(I_DS/dV_DS)];
% G_sens = diff(I_DS/dV_DS);
% 
% R_sens = 1./G_sens;

R_sens = V_DS./I_DS;    % [kohm]


%% C60 without gas
figure(1);
plot(V_DS(:,1),I_DS(:,1)*1e6,...
     'DisplayName',char(labels(:,1)),'LineWidth',1.5,'Color',[0.4660 0.6740 0.1880]);
xlabel('V_{DS} [V]');
ylabel('I_{DS} [\muA]');
hold on;
grid on;
% title('I_{DS} - V_{DS}');    
% title(strcat('I_{DS} - V_{DS}',' (',labels(:,1)),')');    
legend('-DynamicLegend');
legend('show');
legend('Location','northwest');

print -depsc epsFig_C60_nogas;




%% Selection of I-V curves
list2 = {%'All',...                       % gas = 1:1:number_target;
         'Ammonia (NH3)',...              % gas = [2,3];
         'Argon (Ar)',...                 % gas = [4];
         'Butane (C4H10)',...             % gas = [13];
         'Carbon monoxide (CO)',...       % gas = [5];
         'Carbon dioxide (CO2)',...       % gas = [6];
         'Lead chloride (PbCl2)',...      % gas = [25,26,27];
         'Lead oxide (PbO)',...           % gas = [22,23,24];
         'Lead sulfate (PbSO4)',...       % gas = [14,15,16,17,18];      
         'Methane (CH4)',...              % gas = [12];
         'Nitrogen (N2)',...              % gas = [7];
         'Nitric oxide (NO)',...          % gas = [19,20,21];
         'Nitrogen dioxide (NO2)',...     % gas = [28,29,30];
         'Oxygen (O2)',...                % gas = [11];
         'Water vapor (H20)',...          % gas = [8,9,10];
         };                       

[indx2,tf2] = listdlg('ListString', list2,'SelectionMode','single',...
                      'PromptString','Select gas target');
iv_curves = list2{indx2};    % Selected I-V curves


switch iv_curves
    
%     case 'All'
%         gas_iv = 1:1:number_target;
%         color = zeros(1,number_target);
%         for j = 1:number_target
%             color(j) = char([rand,rand,rand]);
%         end
        

    case 'Ammonia (NH3)'
        gas_iv = [1,2,3];
        color_target = {'black_-','black_--'};
        color = ['#77AC30_-',color_target];

    case 'Argon (Ar)'
        gas_iv = [1,4];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];
    
    case 'Carbon monoxide (CO)'
        gas_iv = [1,5];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];
    
    case 'Carbon dioxide (CO2)'
        gas_iv = [1,6];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];

    case 'Nitrogen (N2)'
        gas_iv = [1,7];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];

    case 'Water vapor (H20)'
        gas_iv = [1,8,9,10];
        color_target = {'black_-','black_--','black_-.'};
        color = ['#77AC30_-',color_target];
    
     case 'Oxygen (O2)'
        gas_iv = [1,11];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];

    case 'Methane (CH4)'
        gas_iv = [1,12];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];

    case 'Butane (C4H10)'
        gas_iv = [1,13];
        color_target = {'black_-'};
        color = ['#77AC30_-',color_target];
    
    case 'Lead sulfate (PbSO4)'
        gas_iv = [1,14,15,16,17,18];
        color_target = {'black_-','black_--','black_-.','black_:','#888888_-'};
        color = ['#77AC30_-',color_target];

    case 'Nitric oxide (NO)'
        gas_iv = [1,19,20,21];
        color_target = {'black_-','black_--','black_-.'};
        color = ['#77AC30_-',color_target];

    case 'Lead oxide (PbO)'
        gas_iv = [1,22,23,24];
        color_target = {'black_-','black_--','black_-.'};
        color = ['#77AC30_-',color_target];

    case 'Lead chloride (PbCl2)'
        gas_iv = [1,25,26,27];
        color_target = {'black_-','black_--','black_-.'};
        color = ['#77AC30_-',color_target];

    case 'Nitrogen dioxide (NO2)'
        gas_iv = [1,28,29,30];
        color_target = {'black_-','black_--','black_-.'};
        color = ['#77AC30_-',color_target];

end


for k_gas = 1:length(gas_iv)
    
    kk_gas = gas_iv(k_gas);
    
    
    figure(2);
    c=find(color{1,k_gas}=='_');
%     plot(V_DS(:,jj_gas),I_DS(:,jj_gas)*1e6,...
%          'DisplayName',labels(jj_gas,:),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
    plot(V_DS(:,kk_gas),I_DS(:,kk_gas)*1e6,...
         'DisplayName',char(labels(:,kk_gas)),'LineWidth',1.5,...
         'Color',char(color{1,k_gas}(1:c-1)),'LineStyle',char(color{1,k_gas}(c+1:end)));
    xlabel('V_{DS} [V]');
    ylabel('I_{DS} [\muA]');
    hold on;
    grid on;
%     title('I_{DS} - V_{DS}')    
    legend('-DynamicLegend');
    legend('show');    
    legend('Location','northwest');

end

switch indx2
    case 11 
        print -depsc epsFig_C60+nogas_NO;
end

% Selection of gas target in atmospheric field
list_atm = {'Argon (Ar)',...                      % gas = [4];
            'Carbon monoxide (CO)',...            % gas = [5];
            'Carbon dioxide (CO2)',...            % gas = [6];
            'Nitrogen (N2)',...                   % gas = [7];
            'Oxygen (O2)',...                     % gas = [11];
            'Water vapor (H20)',...               % gas = [8,9,10];
            };                       


list_targets = {%'All',...                        % gas = 1:1:number_target;
                'No gas',...                      % gas = [1];
                'Ammonia (NH3)',...               % gas = [2,3];
                'Butane (C4H10)',...              % gas = [13];
                'Lead chloride (PbCl2)',...       % gas = [25,26,27];
                'Lead oxide (PbO)',...            % gas = [22,23,24];
                'Lead sulfate (PbSO4)',...        % gas = [14,15,16,17,18];      
                'Methane (CH4)',...               % gas = [12];
                'Nitric oxide (NO)',...           % gas = [19,20,21];
                'Nitrogen dioxide (NO2)',...      % gas = [28,29,30];
                };                       

% In the order: Ar, O2, CO, CO2, N2, H2O (x3 config)

atm_gases = [7,11,4,5,6,8,9,10];          % Atmosphric gases

color_atm = {'blue_-','magenta_-','green_-','red_-','yellow_-','cyan_-','cyan_--','cyan_-.'};


list3 = {%'All',...
         'Ammonia (NH3)',...         
         'Butane (C4H10)',...
         'Lead chloride (PbCl2)',...
         'Lead oxide (PbO)',...
         'Lead sulfate (PbSO4)',...
         'Methane (CH4)',...
         'Nitric oxide (NO)',...
         'Nitrogen dioxide (NO2)',...
         };        


[indx3,tf3] = listdlg('ListString', list3,'SelectionMode','single',...
                      'PromptString','Select gas target');
gas_target = list3{indx3};    % Selected target




switch gas_target

    case 'Ammonia (NH3)'
        gas = [2,3,atm_gases];
        color_target = {'black_-','black_--'};
        color = [color_target,color_atm];

    case 'Methane (CH4)'
        gas = [12,atm_gases];
        color_target = {'black_-'};
        color = [color_target,color_atm];

    case 'Butane (C4H10)'
        gas = [13,atm_gases];
        color_target = {'black_-'};
        color = [color_target,color_atm];
    
    case 'Lead sulfate (PbSO4)'
        gas = [14,15,16,17,18,atm_gases];
        color_target = {'black_-','black_--','black_-.','black_:','#888888_-'};
        color = [color_target,color_atm];

    case 'Nitric oxide (NO)'
        gas = [19,20,21,atm_gases];
        color_target = {'black_-','black_--','black_-.'};
        color = [color_target,color_atm];

    case 'Lead oxide (PbO)'
        gas = [22,23,24,atm_gases];
        color_target = {'black_-','black_--','black_-.'};
        color = [color_target,color_atm];

    case 'Lead chloride (PbCl2)'
        gas = [25,26,27,atm_gases];
        color_target = {'black_-','black_--','black_-.'};
        color = [color_target,color_atm];

    case 'Nitrogen dioxide (NO2)'
        gas = [28,29,30,atm_gases];
        color_target = {'black_-','black_--','black_-.'};
        color = [color_target,color_atm];

end


for j_gas = 1:length(gas)
    
    jj_gas = gas(j_gas);
    
    
%     figure(3);
%     c=find(color{1,j_gas}=='_');
% %     plot(V_DS(:,jj_gas),I_DS(:,jj_gas)*1e6,...
% %          'DisplayName',labels(jj_gas,:),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     plot(V_DS(:,jj_gas),I_DS(:,jj_gas)*1e6,...
%          'DisplayName',char(labels(:,jj_gas)),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     xlabel('V_{DS} [V]');
%     ylabel('I_{DS} [\muA]');
%     hold on;
%     grid on;
% %     title('I_{DS} - V_{DS}')    
%     legend('-DynamicLegend');
%     legend('show');    
%     legend('Location','northwest');



    figure(4);
    c=find(color{1,j_gas}=='_');
%     plot(V_DS(:,jj_gas),Delta_I_DS(:,jj_gas)*1e6,...
%          'DisplayName',labels(jj_gas,:),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
    plot(V_DS(:,jj_gas),Delta_I_DS(:,jj_gas)*1e6,...
         'DisplayName',char(labels(:,jj_gas)),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
    xlabel('V_{DS} [V]');
    ylabel('\DeltaI_{DS} [\muA]');
    hold on;
    grid on;
%     title('\DeltaI_{DS} - V_{DS}')    
    legend('-DynamicLegend');
    legend('show');
    legend('Location','northwest');
    legend('FontSize',6);



%     figure(5);
%     c=find(color{1,j_gas}=='_');
%     plot(V_DS(:,jj_gas),Delta_I_DS_perc(:,jj_gas),...
%          'DisplayName',labels(jj_gas,:),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     plot(V_DS(:,jj_gas),Delta_I_DS_perc(:,jj_gas),...
%          'DisplayName',char(labels(:,jj_gas)),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     xlabel('V_{DS} [V]');
%     ylabel('\DeltaI_{DS} [%]');
%     hold on;
%     grid on;
%     title('\DeltaI_{DS,%} - V_{DS}')    
%     legend('-DynamicLegend');
%     legend('show');
%     legend('Location','southeast');
% 
% 
% 
% 
%     figure(6);
%     c=find(color{1,j_gas}=='_');
%     plot(V_DS(:,jj_gas),R_sens(:,jj_gas)/1e3,...
%          'DisplayName',labels(jj_gas,:),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     plot(V_DS(:,jj_gas),R_sens(:,jj_gas)/1e3,...
%          'DisplayName',char(labels(:,jj_gas)),'LineWidth',1.5,'Color',char(color{1,j_gas}(1:c-1)),'LineStyle',char(color{1,j_gas}(c+1:end)));
%     xlabel('V_{DS} [V]');
%     ylabel('R_{sens} [k\Omega]');
%     hold on;
%     grid on;
%     title('R_{sens} - V_{DS}')    
%     legend('-DynamicLegend');
%     legend('show');
%     legend('Location','northeast');

end


switch indx3
    case 2 
        print -depsc epsFig_C60_atm_C4H10_DeltaIds;

    case 6 
        print -depsc epsFig_C60_atm_CH4_DeltaIds;

    case 1
        print -depsc epsFig_C60_atm_NH3_DeltaIds;

    case 7
        print -depsc epsFig_C60_atm_NO_DeltaIds;

    case 8
        print -depsc epsFig_C60_atm_NO2_DeltaIds;
end



% %% All I-V trans-characteristics
% for j = 1:number_target
% 
%     figure(7);
%     plot(V_DS(:,j),I_DS(:,j)*1e6,...
%          'DisplayName',char(labels(:,j)),'LineWidth',1.5);
%     xlabel('V_{DS} [V]');
%     ylabel('I_{DS} [\muA]');
%     hold on;
%     grid on;
%     % title('I_{DS} - V_{DS}');    
%     % title(strcat('I_{DS} - V_{DS}',' (',labels(:,1)),')');    
%     legend('-DynamicLegend');
%     legend('show');
%     legend('Location','northwest');
% 
% end



